/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.ZoomDirection;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderOverlay;
import io.github.mortuusars.exposure.client.MouseHandler;
import io.github.mortuusars.exposure.gui.screen.camera.button.CompositionGuideButton;
import io.github.mortuusars.exposure.gui.screen.camera.button.FlashModeButton;
import io.github.mortuusars.exposure.gui.screen.camera.button.FocalLengthButton;
import io.github.mortuusars.exposure.gui.screen.camera.button.FrameCounterButton;
import io.github.mortuusars.exposure.gui.screen.camera.button.ShutterSpeedButton;
import io.github.mortuusars.exposure.gui.screen.element.IElementWithTooltip;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ViewfinderControlsScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/viewfinder/viewfinder_camera_controls.png");
    private final Player player;
    private final ClientLevel level;
    private final long openedAtTimestamp;

    public ViewfinderControlsScreen() {
        super((Component)Component.m_237119_());
        this.player = Minecraft.m_91087_().f_91074_;
        this.level = Minecraft.m_91087_().f_91073_;
        assert (this.level != null);
        this.openedAtTimestamp = this.level.m_46467_();
        Minecraft.m_91087_().f_91068_.m_90926_(true);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        this.refreshMovementKeys();
        Minecraft.m_91087_().m_91279_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.refreshMovementKeys();
        int leftPos = (this.f_96543_ - 256) / 2;
        int topPos = Math.round(ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height - 256.0f);
        CameraInHand camera = CameraInHand.getActive(this.player);
        Preconditions.checkState((!camera.isEmpty() ? 1 : 0) != 0, (Object)"Player should hold an Active Camera at this point.");
        boolean hasFlashAttached = camera.getItem().getAttachment(camera.getStack(), CameraItem.FLASH_ATTACHMENT).isPresent();
        int sideButtonsWidth = 48;
        int buttonWidth = 15;
        int elementX = leftPos + 128 - (sideButtonsWidth + 1 + buttonWidth + 1 + (hasFlashAttached ? buttonWidth + 1 : 0) + sideButtonsWidth) / 2;
        int elementY = topPos + 238;
        ShutterSpeedButton shutterSpeedButton = new ShutterSpeedButton(this, leftPos + 94, topPos + 226, 69, 12, 112, 0, TEXTURE);
        this.m_142416_((GuiEventListener)shutterSpeedButton);
        FocalLengthButton focalLengthButton = new FocalLengthButton(this, elementX, elementY, 48, 18, 0, 0, TEXTURE);
        this.m_169394_((Widget)focalLengthButton);
        ImageButton separator1 = new ImageButton(elementX += focalLengthButton.m_5711_(), elementY, 1, 18, 111, 0, TEXTURE, pButton -> {});
        this.m_169394_((Widget)separator1);
        CompositionGuideButton compositionGuideButton = new CompositionGuideButton(this, elementX += separator1.m_5711_(), elementY, 15, 18, 48, 0, TEXTURE);
        this.m_142416_((GuiEventListener)compositionGuideButton);
        ImageButton separator2 = new ImageButton(elementX += compositionGuideButton.m_5711_(), elementY, 1, 18, 111, 0, TEXTURE, pButton -> {});
        this.m_169394_((Widget)separator2);
        elementX += separator2.m_5711_();
        if (hasFlashAttached) {
            FlashModeButton flashModeButton = new FlashModeButton(this, elementX, elementY, 15, 18, 48, 0, TEXTURE);
            this.m_142416_((GuiEventListener)flashModeButton);
            ImageButton separator3 = new ImageButton(elementX += flashModeButton.m_5711_(), elementY, 1, 18, 111, 0, TEXTURE, pButton -> {});
            this.m_169394_((Widget)separator3);
            elementX += separator3.m_5711_();
        }
        FrameCounterButton frameCounterButton = new FrameCounterButton(this, elementX, elementY, 48, 18, 63, 0, TEXTURE);
        this.m_169394_((Widget)frameCounterButton);
    }

    private void refreshMovementKeys() {
        Consumer<KeyMapping> update = keyMapping -> {
            if (keyMapping.f_90816_.m_84868_() == InputConstants.Type.MOUSE) {
                keyMapping.m_7249_(MouseHandler.isMouseButtonHeld(keyMapping.f_90816_.m_84873_()));
            } else {
                long windowId = Minecraft.m_91087_().m_91268_().m_85439_();
                keyMapping.m_7249_(InputConstants.m_84830_((long)windowId, (int)keyMapping.f_90816_.m_84873_()));
            }
        };
        update.accept(ExposureClient.getViewfinderControlsKey());
        Options opt = Minecraft.m_91087_().f_91066_;
        update.accept(opt.f_92085_);
        update.accept(opt.f_92087_);
        update.accept(opt.f_92086_);
        update.accept(opt.f_92088_);
        update.accept(opt.f_92089_);
        update.accept(opt.f_92091_);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (!ViewfinderClient.isLookingThrough()) {
            this.m_7379_();
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        poseStack.m_85836_();
        float viewfinderScale = ViewfinderOverlay.getScale();
        if (viewfinderScale != 1.0f) {
            poseStack.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)((float)this.f_96544_ / 2.0f), 0.0);
            poseStack.m_85841_(viewfinderScale, viewfinderScale, viewfinderScale);
            poseStack.m_85837_((double)((float)(-this.f_96543_) / 2.0f), (double)((float)(-this.f_96544_) / 2.0f), 0.0);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        for (Widget renderable : this.f_169369_) {
            if (!(renderable instanceof IElementWithTooltip)) continue;
            IElementWithTooltip tooltipElement = (IElementWithTooltip)renderable;
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable;
            if (!widget.f_93624_ || !widget.m_198029_()) continue;
            tooltipElement.m_7428_(poseStack, mouseX, mouseY);
            break;
        }
        poseStack.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handled = super.m_6375_(mouseX, mouseY, button);
        if (!handled && button == 1 && Minecraft.m_91087_().f_91072_ != null) {
            ItemStack itemInHand;
            InteractionHand activeHand = CameraInHand.getActiveHand(this.player);
            if (activeHand != null && (itemInHand = this.player.m_21120_(activeHand)).m_41720_() instanceof CameraItem) {
                Minecraft.m_91087_().f_91072_.m_233721_(this.player, activeHand);
            }
            handled = true;
        }
        return handled;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (ExposureClient.getViewfinderControlsKey().m_90830_(button)) {
            if (this.level.m_46467_() - this.openedAtTimestamp >= 5L) {
                this.m_7379_();
            }
            return false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (ExposureClient.getViewfinderControlsKey().m_90832_(keyCode, scanCode)) {
            if (this.level.m_46467_() - this.openedAtTimestamp >= 5L) {
                this.m_7379_();
            }
            return false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Preconditions.checkState((this.f_96541_ != null ? 1 : 0) != 0);
        boolean handled = super.m_7933_(keyCode, scanCode, modifiers);
        if (handled) {
            return true;
        }
        if (keyCode == 334 || keyCode == 61) {
            ViewfinderClient.zoom(ZoomDirection.IN, true);
            return true;
        }
        if (keyCode == 333 || keyCode == 45) {
            ViewfinderClient.zoom(ZoomDirection.OUT, true);
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!super.m_6050_(mouseX, mouseY, delta)) {
            ViewfinderClient.zoom(delta > 0.0 ? ZoomDirection.IN : ZoomDirection.OUT, true);
            return true;
        }
        return false;
    }
}

